#pragma once

#ifdef LIBTERAFAST_EXPORTS
#define LIBTERAFAST_API __declspec(dllexport)
#else
#define LIBTERAFAST_API __declspec(dllimport)
#endif

#include <stdio.h>





#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif


typedef  signed __int16 TF_ELEMENT;
typedef  TF_ELEMENT *   TF_DATA;
	
LIBTERAFAST_API int frameSize, frameLength, dataLength;  //dataLength = frameSize*frameLength
LIBTERAFAST_API char deviceIDstring[32];




#define TF_MAX_VALUE ((1<<15)-1)

#define TF_DEFAULT_PERIOD 200
#define TF_DEFAULT_THRESHOLD 10
#define TF_DEFAULT_FRAMELENGTH 64
#define TF_MAX_FRAMELENGTH 4096



typedef  int    TF_RES;
#define TF_OK 0
#define TF_FAILED -9999
#define TF_CANCELLED -9998
#define TF_ERR_WRONG_PARAMETERS -9997
#define TF_NOTRUNNING -9996
#define TF_ERR_SIZE_MISMATCH -9995
#define TF_OUTPUT_ERROR -9994
#define TF_INPUT_ERROR -9993
#define TF_NOTCONFIGURED -9992
#define TF_ERR_RUNNING -9991
#define TF_PATHNOTFOUND -9990
#define TF_TIMEOUT -9989


//Initialize device
LIBTERAFAST_API TF_RES tfInit(void);

//Close the device
LIBTERAFAST_API TF_RES tfClose(void);

//Starts data acquisition and processing
LIBTERAFAST_API TF_RES tfStart(void);


//Stops data acquisition and processing
LIBTERAFAST_API TF_RES tfStop(void);

//Checks whether the acquisition is running
LIBTERAFAST_API int tfIsRunning(void);

//Read processed data to buffer with timeout (acquistion must be running). Timeout value in milliseconds; if timeout elapses, function returns TF_TIMEOUT. 
// Use 0xFFFFFFFF for timeout to get infinite timeout and make tfRead_T equivalent to tfRead
LIBTERAFAST_API TF_RES tfRead(TF_DATA buffer);
LIBTERAFAST_API TF_RES tfRead_T(TF_DATA buffer, int timeout);

//Read unprocessed data to buffer (acquistion must be running). Timeout value in milliseconds; if timeout elapses, function returns TF_TIMEOUT.
// Use 0xFFFFFFFF for timeout to get infinite timeout and make tfReadRaw equivalent to tfReadRaw_T
LIBTERAFAST_API TF_RES tfReadRaw(TF_DATA buffer);
LIBTERAFAST_API TF_RES tfReadRaw_T(TF_DATA buffer, int timeout);

//Reset line count for a frame to zero (may be useful with external synchronization).
LIBTERAFAST_API TF_RES tfResetLineCount(void);

// Turns on/off difference mode
LIBTERAFAST_API TF_RES tfSetDifference(int on);

// Set the number of lines in a single frame  ( frameLength )
LIBTERAFAST_API TF_RES tfSetFrameLength(int size);

// Returns the number of lines in a current frame  ( frameLength )
LIBTERAFAST_API int tfGetFrameLength(void);


// Set the time period between lines in microseconds; minimal value is 100. If the value is beyond admissible range 
// (see tfGetPeriodRange() ), TF_ERR_WRONG_PARAMETERS is returned.

LIBTERAFAST_API TF_RES tfSetPeriod(int period);
// Returns the  time period between lines.
LIBTERAFAST_API int tfGetPeriod(void);

//Provides admissible range for the period value.
LIBTERAFAST_API TF_RES tfGetPeriodRange(int * min, int * max);



// Set the acquisition rate in lines/sec (note that this is line acquisition rate, frame rate is frameLength times slower).
// This is a helper function for SetPeriod(), the actual rate will be a rounded value corresponding to a nearest integer period.
LIBTERAFAST_API TF_RES tfSetRate(double rate);

// Returns the acquisition rate in lines/sec (note that this is line acquisition rate, frame rate is frameLength times slower).
// The return value may be not equal to the argument of previous SetRate() call due to rounding errors.
LIBTERAFAST_API double tfGetRate(void);

//Turns sync output signal on or off.
LIBTERAFAST_API TF_RES tfSetSyncOut(int on);
LIBTERAFAST_API int tfGetSyncOut(void);

// Turns external sync mode on or off. tfRead() and tfReadRaw() will block if you call this function to turn
// external sync mode on but no sync signal is supplied to the corresponding input.
LIBTERAFAST_API TF_RES tfSetExternalSync(int on);

// Returns status of external sync mode.
LIBTERAFAST_API int tfGetExternalSync(void);

// Sets trigger edge for external sync signal. 0 for falling edge, 1 for rising edge.
LIBTERAFAST_API TF_RES tfSetEdge(int rise);
LIBTERAFAST_API int tfGetEdge(void);

//Sets divider for external sync signal frequency, 1 <= div <= 32768
LIBTERAFAST_API TF_RES  tfSetSyncDivider(int div);
LIBTERAFAST_API int tfGetSyncDivider(void);


//Sets holdoff parameter for the external sync signal, 0 <= holdoff <= 15.
// It corresponsd to minimum 2 ^ holdoff microseconds delay between active edges.
LIBTERAFAST_API TF_RES  tfSetSyncHoldoff(int holdoff);
LIBTERAFAST_API int tfGetSyncHoldoff(void);


// Format of the config file: header = <magic string (6 bytes)><frameSize (2 bytes)><0x02><0x01>
// main body  = <normalizations (2*2*frameSize)><background (2*size)>
LIBTERAFAST_API TF_RES tfLoadConfig(FILE *stream);
LIBTERAFAST_API TF_RES tfSaveConfig( FILE *stream);

// Helper functions.  The argument containing path to the config file is ANSI string for tfLoadConfigFrom(), while it is a wide-character string for tfLoadConfigFrom_w().
// If the file "filename" cannot be opened for any reason, returns TF_PATHNOTFOUND.
LIBTERAFAST_API TF_RES tfLoadConfigFrom(const char *filename);
LIBTERAFAST_API TF_RES tfLoadConfigFrom_w(const wchar_t *filename);


// Helper functions.  The argument containing path to the config file is ANSI string for tfSaveConfigAs(), while it is a wide-character string for tfSaveConfigAs_w().
// If the file already exists, it will be overwritten silently. If the file "filename" cannot be opened for any reason, returns TF_PATHNOTFOUND.
LIBTERAFAST_API TF_RES tfSaveConfigAs(const char *filename);
LIBTERAFAST_API TF_RES tfSaveConfigAs_w(const wchar_t *filename);

// Ticker callback function. Completion parameter varies from 0 (just started) to 1 (finished). The function should return TRUE to request abort of the operation.
typedef  int (*TF_ticker_t)(double completion);

// Record background data
LIBTERAFAST_API TF_RES tfRecordBackground(TF_ticker_t callback);

// Record normalization data
LIBTERAFAST_API TF_RES tfRecordNormalization(TF_ticker_t callback);


//Select nomaliztion (0 - default, 1 - recorded)
LIBTERAFAST_API TF_RES tfSelectNorm(int i);

// Set threshold value for SNR during normalization to mark pixels unperforming. If argument is below 1, the TF_DEFAULT_THRESHOLD is used.
LIBTERAFAST_API TF_RES tfSetThreshold(double threshold);


LIBTERAFAST_API int tfFrameLength(void);
LIBTERAFAST_API int tfFrameSize(void);
LIBTERAFAST_API int tfDataLength(void);
LIBTERAFAST_API char* tfDeviceID(void);

#ifdef __cplusplus
}
#endif